<?php
namespace MailPoetVendor\Doctrine\DBAL;
if (!defined('ABSPATH')) exit;
use MailPoetVendor\Doctrine\DBAL\Abstraction\Result;
use MailPoetVendor\Doctrine\DBAL\Driver\Exception;
use MailPoetVendor\Doctrine\DBAL\Driver\Statement as DriverStatement;
use MailPoetVendor\Doctrine\DBAL\Exception\NoKeyValue;
use MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform;
use MailPoetVendor\Doctrine\DBAL\Result as BaseResult;
use MailPoetVendor\Doctrine\DBAL\Types\Type;
use MailPoetVendor\Doctrine\Deprecations\Deprecation;
use IteratorAggregate;
use PDO;
use PDOStatement;
use ReturnTypeWillChange;
use Throwable;
use Traversable;
use function array_shift;
use function func_get_args;
use function is_array;
use function is_string;
class Statement implements IteratorAggregate, DriverStatement, Result
{
 protected $sql;
 protected $params = [];
 protected $types = [];
 protected $stmt;
 protected $platform;
 protected $conn;
 public function __construct($sql, Connection $conn)
 {
 $this->sql = $sql;
 $this->stmt = $conn->getWrappedConnection()->prepare($sql);
 $this->conn = $conn;
 $this->platform = $conn->getDatabasePlatform();
 }
 public function bindValue($param, $value, $type = ParameterType::STRING)
 {
 $this->params[$param] = $value;
 $this->types[$param] = $type;
 if ($type !== null) {
 if (is_string($type)) {
 $type = Type::getType($type);
 }
 if ($type instanceof Type) {
 $value = $type->convertToDatabaseValue($value, $this->platform);
 $bindingType = $type->getBindingType();
 } else {
 $bindingType = $type;
 }
 return $this->stmt->bindValue($param, $value, $bindingType);
 }
 return $this->stmt->bindValue($param, $value);
 }
 public function bindParam($param, &$variable, $type = ParameterType::STRING, $length = null)
 {
 $this->params[$param] = $variable;
 $this->types[$param] = $type;
 if ($this->stmt instanceof PDOStatement) {
 $length = $length ?? 0;
 }
 return $this->stmt->bindParam($param, $variable, $type, $length);
 }
 public function execute($params = null)
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/4580', 'Statement::execute() is deprecated, use Statement::executeQuery() or Statement::executeStatement() instead');
 if (is_array($params)) {
 $this->params = $params;
 }
 $logger = $this->conn->getConfiguration()->getSQLLogger();
 if ($logger) {
 $logger->startQuery($this->sql, $this->params, $this->types);
 }
 try {
 $stmt = $this->stmt->execute($params);
 } catch (Throwable $ex) {
 if ($logger) {
 $logger->stopQuery();
 }
 $this->conn->handleExceptionDuringQuery($ex, $this->sql, $this->params, $this->types);
 }
 if ($logger) {
 $logger->stopQuery();
 }
 return $stmt;
 }
 public function executeQuery(array $params = []) : BaseResult
 {
 if ($params === []) {
 $params = null;
 // Workaround as long execute() exists and used internally.
 }
 $this->execute($params);
 return new ForwardCompatibility\Result($this);
 }
 public function executeStatement(array $params = []) : int
 {
 if ($params === []) {
 $params = null;
 // Workaround as long execute() exists and used internally.
 }
 $this->execute($params);
 return $this->rowCount();
 }
 public function closeCursor()
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/4049', 'Statement::closeCursor() is deprecated, use Result::free() instead.');
 return $this->stmt->closeCursor();
 }
 public function columnCount()
 {
 return $this->stmt->columnCount();
 }
 public function errorCode()
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/3507', 'Connection::errorCode() is deprecated, use getCode() or getSQLState() on Exception instead.');
 return $this->stmt->errorCode();
 }
 public function errorInfo()
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/3507', 'Connection::errorInfo() is deprecated, use getCode() or getSQLState() on Exception instead.');
 return $this->stmt->errorInfo();
 }
 public function setFetchMode($fetchMode, $arg2 = null, $arg3 = null)
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/4019', 'Statement::setFetchMode() is deprecated, use explicit Result::fetch*() APIs instead.');
 if ($arg2 === null) {
 return $this->stmt->setFetchMode($fetchMode);
 }
 if ($arg3 === null) {
 return $this->stmt->setFetchMode($fetchMode, $arg2);
 }
 return $this->stmt->setFetchMode($fetchMode, $arg2, $arg3);
 }
 #[ReturnTypeWillChange]
 public function getIterator()
 {
 Deprecation::trigger('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/4019', 'Statement::getIterator() is deprecated, use Result::iterateNumeric(), iterateAssociative() ' . 'or iterateColumn() instead.');
 return $this->stmt;
 }
 public function fetch($fetchMode = null, $cursorOrientation = PDO::FETCH_ORI_NEXT, $cursorOffset = 0)
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/4019', 'Statement::fetch() is deprecated, use Result::fetchNumeric(), fetchAssociative() or fetchOne() instead.');
 return $this->stmt->fetch(...func_get_args());
 }
 public function fetchAll($fetchMode = null, $fetchArgument = null, $ctorArgs = null)
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/4019', 'Statement::fetchAll() is deprecated, use Result::fetchAllNumeric(), fetchAllAssociative() or ' . 'fetchFirstColumn() instead.');
 if ($ctorArgs !== null) {
 return $this->stmt->fetchAll($fetchMode, $fetchArgument, $ctorArgs);
 }
 if ($fetchArgument !== null) {
 return $this->stmt->fetchAll($fetchMode, $fetchArgument);
 }
 return $this->stmt->fetchAll($fetchMode);
 }
 public function fetchColumn($columnIndex = 0)
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/4019', 'Statement::fetchColumn() is deprecated, use Result::fetchOne() instead.');
 return $this->stmt->fetchColumn($columnIndex);
 }
 public function fetchNumeric()
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__);
 try {
 if ($this->stmt instanceof Result) {
 return $this->stmt->fetchNumeric();
 }
 return $this->stmt->fetch(FetchMode::NUMERIC);
 } catch (Exception $e) {
 $this->conn->handleDriverException($e);
 }
 }
 public function fetchAssociative()
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__);
 try {
 if ($this->stmt instanceof Result) {
 return $this->stmt->fetchAssociative();
 }
 return $this->stmt->fetch(FetchMode::ASSOCIATIVE);
 } catch (Exception $e) {
 $this->conn->handleDriverException($e);
 }
 }
 public function fetchOne()
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__);
 try {
 if ($this->stmt instanceof Result) {
 return $this->stmt->fetchOne();
 }
 return $this->stmt->fetch(FetchMode::COLUMN);
 } catch (Exception $e) {
 $this->conn->handleDriverException($e);
 }
 }
 public function fetchAllNumeric() : array
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__);
 try {
 if ($this->stmt instanceof Result) {
 return $this->stmt->fetchAllNumeric();
 }
 return $this->stmt->fetchAll(FetchMode::NUMERIC);
 } catch (Exception $e) {
 $this->conn->handleDriverException($e);
 }
 }
 public function fetchAllAssociative() : array
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__);
 try {
 if ($this->stmt instanceof Result) {
 return $this->stmt->fetchAllAssociative();
 }
 return $this->stmt->fetchAll(FetchMode::ASSOCIATIVE);
 } catch (Exception $e) {
 $this->conn->handleDriverException($e);
 }
 }
 public function fetchAllKeyValue() : array
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__);
 $this->ensureHasKeyValue();
 $data = [];
 foreach ($this->fetchAllNumeric() as [$key, $value]) {
 $data[$key] = $value;
 }
 return $data;
 }
 public function fetchAllAssociativeIndexed() : array
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__);
 $data = [];
 foreach ($this->fetchAll(FetchMode::ASSOCIATIVE) as $row) {
 $data[array_shift($row)] = $row;
 }
 return $data;
 }
 public function fetchFirstColumn() : array
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__);
 try {
 if ($this->stmt instanceof Result) {
 return $this->stmt->fetchFirstColumn();
 }
 return $this->stmt->fetchAll(FetchMode::COLUMN);
 } catch (Exception $e) {
 $this->conn->handleDriverException($e);
 }
 }
 public function iterateNumeric() : Traversable
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__);
 try {
 if ($this->stmt instanceof Result) {
 while (($row = $this->stmt->fetchNumeric()) !== \false) {
 (yield $row);
 }
 } else {
 while (($row = $this->stmt->fetch(FetchMode::NUMERIC)) !== \false) {
 (yield $row);
 }
 }
 } catch (Exception $e) {
 $this->conn->handleDriverException($e);
 }
 }
 public function iterateAssociative() : Traversable
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__);
 try {
 if ($this->stmt instanceof Result) {
 while (($row = $this->stmt->fetchAssociative()) !== \false) {
 (yield $row);
 }
 } else {
 while (($row = $this->stmt->fetch(FetchMode::ASSOCIATIVE)) !== \false) {
 (yield $row);
 }
 }
 } catch (Exception $e) {
 $this->conn->handleDriverException($e);
 }
 }
 public function iterateKeyValue() : Traversable
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__);
 $this->ensureHasKeyValue();
 foreach ($this->iterateNumeric() as [$key, $value]) {
 (yield $key => $value);
 }
 }
 public function iterateAssociativeIndexed() : Traversable
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__);
 while (($row = $this->stmt->fetch(FetchMode::ASSOCIATIVE)) !== \false) {
 (yield array_shift($row) => $row);
 }
 }
 public function iterateColumn() : Traversable
 {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__);
 try {
 if ($this->stmt instanceof Result) {
 while (($value = $this->stmt->fetchOne()) !== \false) {
 (yield $value);
 }
 } else {
 while (($value = $this->stmt->fetch(FetchMode::COLUMN)) !== \false) {
 (yield $value);
 }
 }
 } catch (Exception $e) {
 $this->conn->handleDriverException($e);
 }
 }
 public function rowCount()
 {
 return $this->stmt->rowCount();
 }
 public function free() : void
 {
 if ($this->stmt instanceof Result) {
 $this->stmt->free();
 return;
 }
 $this->stmt->closeCursor();
 }
 public function getWrappedStatement()
 {
 return $this->stmt;
 }
 private function ensureHasKeyValue() : void
 {
 $columnCount = $this->columnCount();
 if ($columnCount < 2) {
 throw NoKeyValue::fromColumnCount($columnCount);
 }
 }
}
